import { Component, Output, EventEmitter, OnInit } from '@angular/core';
import { AthleteService } from './athlete.service';
import { Athlete } from "./athlete";
import { Observable } from "rxjs/Observable";


@Component({
  selector: 'app-athlete-list',
  template: `
  <ol>
    <li *ngFor="let athlete of athletes | async">
      <app-athlete (click)="select(athlete)" [athlete]="athlete">
    </app-athlete></li>
  </ol>
  `,
})
export class AthleteListComponent implements OnInit {
  athletes: Observable<Athlete[]>;
  @Output() selected = new EventEmitter<Athlete>();
  constructor(private athleteService: AthleteService){  }

  getAthletes() {
    this.athletes = this.athleteService.getAthletes();
  } 

  ngOnInit(){this.getAthletes();}

  select(selectedAthlete: Athlete){
    this.selected.emit(selectedAthlete);
  }
}